local appName="DC-24 Tx Telemetry"

local function dump(o)
   if type(o) == 'table' then
      local s = '{ '
      for k,v in pairs(o) do
         -- if type(k) ~= 'number' then k = '"'..k..'"' end
         s = s .. k..'=' .. dump(v) .. ','
      end
      return s .. '} '
   else
      return tostring(o)
   end
end

local function printForm()
  local txTel = system.getTxTelemetry();
  lcd.drawText(10,20,string.format("Rx1: %dV, Q=%d%%, A1/2=%d/%d",txTel.rx1Voltage,txTel.rx1Percent,txTel.RSSI[1],txTel.RSSI[2]))
  lcd.drawText(10,40,string.format("Rx2: %dV, Q=%d%%, A1/2=%d/%d",txTel.rx2Voltage,txTel.rx2Percent,txTel.RSSI[3],txTel.RSSI[4]))
  lcd.drawText(10,60,string.format("RxB: %dV, Q=%d%%, A1/2=%d/%d",txTel.rxBVoltage,txTel.rxBPercent,txTel.RSSI[5],txTel.RSSI[6]))
  lcd.drawText(10,80,string.format("Tx: %.2fV, Batt=%d%%, I=%.2fmA",txTel.txVoltage,txTel.txBattPercent,txTel.txCurrent))
  
end

local function init()
  system.registerForm(1,MENU_MAIN,appName,nil,nil,printForm);
end
--------------------------------------------------------------------

return { init=init, loop=loop, author="JETI model", version="1.00",name=appName}