local appName="Renderer test" 

local ren=lcd.renderer()
ren:addPoint(5,75) 
ren:addPoint(10,50)
ren:addPoint(20,100)
ren:addPoint(30,75)
ren:addPoint(50,75)

local renShape=lcd.renderer()
local homeShape = {
  { 0, -50},
  {-40,  40},
  { 0,  20},
  { 40,  40}
}
local heading = 0

-- *****************************************************
-- Draw a shape
-- *****************************************************
local function drawShape(col, row, shape, rotation)
  sinShape = math.sin(rotation)
  cosShape = math.cos(rotation)
  renShape:reset()
  for index, point in pairs(shape) do
    renShape:addPoint(
      col + (point[1] * cosShape - point[2] * sinShape + 0.5),
      row + (point[1] * sinShape + point[2] * cosShape + 0.5)
    ) 
  end
  renShape:renderPolygon()
end

--------------------------------------------------------------------
-- Init function
--------------------------------------------------------------------
local function initForm(formId) 
  
      
end

--------------------------------------------------------------------
-- Init function
--------------------------------------------------------------------
local function printForm(formId)
  lcd.setColor(lcd.getFgColor())  
  ren:renderPolyline(4) 
  drawShape(200, 80, homeShape, math.rad(heading)) 
end
 
local function loop()
  heading = (heading + 1) % 360 
end 
--------------------------------------------------------------------
-- Init function
--------------------------------------------------------------------
local function init() 
  system.registerForm(1,MENU_APPS,appName,initForm,nil,printForm) 
end 
return { init=init, loop=loop, author="JETI model", version="1.00",name=appName}