
--------------------------------------------------------------------
local appName="Test 29 - Checkbox/Servo Test" 
local showServo=true
local componentIndex
--------------------------------------------------------------------
local function checkClicked(value)
  showServo = not value
  form.setValue(componentIndex,showServo)
end  
--------------------------------------------------------------------
local function initForm(formID)  
  form.addRow(2)
  form.addLabel({label="Show servo outputs",width=270})
  componentIndex = form.addCheckbox(showServo,checkClicked)
end 
 
--------------------------------------------------------------------


local function printForm() 
  if(not showServo) then
    return 
  end  
  local s1,s2,s3,s4,s5,s6,s7,s8 = system.getInputs("O1","O2","O3","O4","O5","O6","O7","O8")
  local values={s1,s2,s3,s4,s5,s6,s7,s8}
  local offset=25
  local offsetx=10
  local textVal
  for i=1,8 do
    lcd.drawText(offsetx,offset,string.format("Ch %d:",i))
    textVal = string.format("%.1f %%",values[i]*100)
    lcd.drawText(offsetx+130 - lcd.getTextWidth(FONT_NORMAL,textVal),offset,textVal)
    offset=offset + 20
    if(i==4) then 
      offsetx = offsetx + 155
      offset = 25  
    end  
  end     
end 
 
--------------------------------------------------------------------
-- Init function
local function init()
  system.registerForm(1,MENU_MAIN,appName,initForm,keyPressed,printForm); 
end 
--------------------------------------------------------------------

return { init=init, author="JETI model", version="1.00",name=appName}
