
--------------------------------------------------------------------------------
-- Prints the average period between calls of the Loop function
local lastTime
local avgTime
-- Calculates the average period
local function loop()
  local newTime = system.getTimeCounter()
  local delta = newTime - lastTime
  lastTime = newTime
  if (avgTime == 0) then 
    avgTime = delta
  else 
    avgTime = avgTime * 0.95 + delta * 0.05
  end
end
-- Displays an average time between loops
local function printForm() 
  lcd.drawText(10,30,string.format("Avg. time: %.2fms",avgTime),FONT_MAXI) 
end

--------------------------------------------------------------------------------
local function init() 
  system.registerForm(1,MENU_MAIN,"Test 5 - Avg. time",nil, nil,printForm) 
  lastTime = system.getTimeCounter()
  avgTime = 0
end
--------------------------------------------------------------------------------

return {init=init, loop=loop, author="JETI model", version="1.0"}
