local appName="Test 25 - Open/Close form"
local lastTimeChecked
local rowIndex
--------------------------------------------------------------------

local function initForm(formID)
  rowIndex = form.addRow(1)
  form.addLabel({label="Blinking label"}) 
end  

local function keyPressed(key)
  if(key~=KEY_RELEASE) then
    form.close() 
  end
end  

--------------------------------------------------------------------
-- Loop function
local function loop()  
  if( form.getActiveForm() ) then 
    lastTimeChecked = system.getTimeCounter() 
    form.setProperties(rowIndex,{visible = (lastTimeChecked//1000)%2==0}) 
  else   
    if( system.getTimeCounter() > lastTimeChecked + 2000) then
      -- Show the form immediately
      system.registerForm(1,0,appName,initForm,keyPressed);
    end
  end   
end
 
--------------------------------------------------------------------
-- Init function
local function init() 
  lastTimeChecked = system.getTimeCounter() 
end

--------------------------------------------------------------------

return { init=init, loop=loop, author="JETI model", version="1.00",name=appName}