
--------------------------------------------------------------------
local appName="Test 22 - Audio play"
local playedFile
local playedType = 1
local switch
local prevVal = 1

local typeOptions={"Play in background", "Play immediately", "Add to queue"}
local typeValues={AUDIO_BACKGROUND, AUDIO_IMMEDIATE, AUDIO_QUEUE} 
 
-------------------------------------------------------------------- 
local function fileChanged(value)
  playedFile=value
  system.pSave("file",value)   
end

local function typeChanged(value)
  playedType=value
  system.pSave("type",value) 
end

local function switchChanged(value)
  switch=value
  system.pSave("switch",value) 
end 
--------------------------------------------------------------------

local function initForm(formID)
  form.addRow(2)
  form.addLabel({label="Select file"})
  form.addAudioFilebox(playedFile or "", fileChanged)
  
  form.addRow(2)
  form.addLabel({label="Playback type",width=120})
  form.addSelectbox(typeOptions,playedType or 1,false,typeChanged,{width=190})
  
  form.addRow(2)
  form.addLabel({label="Switch"})
  form.addInputbox(switch,true,switchChanged)  
  form.setButton(1,"Play",ENABLED)
end  

local function keyPressed(key)
  if(key==KEY_1) then
    system.playFile(playedFile,typeValues[playedType]) 
  end
end  
 
--------------------------------------------------------------------
-- Init function
local function init()
  system.registerForm(1,MENU_MAIN,appName,initForm,keyPressed); 
  playedFile = system.pLoad("file","")
  switch = system.pLoad("switch")
  playedType = system.pLoad("type",1) 
end
  
--------------------------------------------------------------------
-- Loop function
local function loop() 
  local val = system.getInputsVal(switch)
  if(val and val>0 and prevVal==0) then 
    system.playFile(playedFile,typeValues[playedType])
    prevVal=1 
  elseif(val and val<=0)  then
    prevVal=0    
  end  
  
end          

--------------------------------------------------------------------

return { init=init, loop=loop, author="JETI model", version="1.00",name=appName}
